<header>
    <div class="header-area header-style-two header-transparent" id="header-sticky">
       <div class="header-inner">
          <div class="header-left">
             <div class="header-logo">
                <a href="{{ route('home') }}">
                    @php
                        $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
                        $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
                    @endphp

                    <img class="logo-white" src="{{ asset(setting('site_logo','global')) }}" style="height:{{ $height }};width:{{ $width }};max-width:none" alt="{{ setting('site_title','global') }}">
                    <img class="logo-black" src="{{ asset(setting('site_logo','global')) }}" style="height:{{ $height }};width:{{ $width }};max-width:none" alt="{{ setting('site_title','global') }}">
                </a>
             </div>
             <div class="header-menu d-none d-lg-inline-flex">
                <nav class="td-main-menu" id="mobile-menu">
                   <ul>
                    @foreach($navigations as $navigation)
                        @if($navigation->page_id == null)
                            <li @class([
                                'active' => $navigation->url == Request::url()
                            ])>
                                <a href="{{ $navigation->url }}">{{ $navigation->tname }}</a>
                            </li>
                        @else
                            <li @class([
                                'active' => url($navigation->url) == Request::url()
                            ])>
                                <a href="{{ url($navigation->url) }}">{{ $navigation->tname }}</a>
                            </li>
                        @endif
                    @endforeach
                   </ul>
                </nav>
             </div>
          </div>
          <div class="header-right">
            <div class="header-switcher">
                <div class="switcher-box">
                   <label class="color-switcher">
                      <input type="checkbox" id="themeSwitcher">
                      <span class="slider round"></span>
                   </label>
                </div>
             </div>
             @if(setting('language_switcher'))
                @php
                    $languages = \App\Models\Language::where('status',true)->get();
                    $current_lang = app()->getLocale();
                @endphp
                <div class="header-quick-action">
                    <div class="language-box">
                        <div class="header-lang-item header-lang">
                            <span class="header-lang-toggle" id="header-lang-toggle">
                                <i class="fa-regular fa-globe"></i>
                                <span class="lang-text">
                                    {{ $languages->where('locale',$current_lang)->value('name') }}
                                </span>
                            </span>
                            <ul id="language-list" class="hidden">
                                @foreach(\App\Models\Language::where('status',true)->get() as $lang)
                                    @if ($current_lang != $lang->locale)
                                        <li>
                                            <a href="{{ route('language-update',['name'=> $lang->locale]) }}" data-lang="{{$lang->name}}" class="change_lang">
                                                {{$lang->name}} <span class="icon"></span>
                                            </a>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
             @endif
             <div class="header-action">
                <div class="header-btn-wrap d-none d-xxl-inline-flex">
                    @auth('web')
                        <a class="site-btn gdt-btn" href="{{ route('user.dashboard') }}">
                            {{ __('Dashboard') }}
                        </a>
                    @else
                        <a class="site-btn white-btn" href="{{ route('register') }}">
                            <span>
                                <svg width="19" height="21" viewBox="0 0 19 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.2154 13.2178C13.8062 12.9004 14.4825 12.7197 15.2027 12.7197H15.2051C15.2784 12.7197 15.3126 12.6318 15.2589 12.583C14.5099 11.9108 13.6543 11.368 12.7271 10.9766C12.7173 10.9717 12.7076 10.9692 12.6978 10.9644C14.2139 9.86328 15.2003 8.07373 15.2003 6.05469C15.2003 2.70996 12.4952 0 9.15777 0C5.82037 0 3.11774 2.70996 3.11774 6.05469C3.11774 8.07373 4.10406 9.86328 5.62262 10.9644C5.61285 10.9692 5.60309 10.9717 5.59332 10.9766C4.50201 11.438 3.52301 12.0996 2.68073 12.9443C1.84329 13.7802 1.1766 14.7712 0.717834 15.8618C0.26645 16.9298 0.022843 18.0741 6.10498e-05 19.2334C-0.000590574 19.2595 0.00397981 19.2854 0.013503 19.3096C0.0230262 19.3339 0.0373095 19.356 0.0555113 19.3747C0.073713 19.3933 0.0954649 19.4082 0.119485 19.4183C0.143506 19.4284 0.169309 19.4336 0.195374 19.4336H1.65778C1.76276 19.4336 1.85065 19.3481 1.85309 19.2432C1.90192 17.3584 2.65631 15.5933 3.99176 14.2554C5.37115 12.8711 7.20709 12.1094 9.16022 12.1094C10.5445 12.1094 11.8726 12.4927 13.0176 13.2104C13.0471 13.2289 13.0808 13.2393 13.1155 13.2406C13.1503 13.2419 13.1847 13.234 13.2154 13.2178ZM9.16022 10.2539C8.04205 10.2539 6.98981 9.81689 6.19635 9.02344C5.80596 8.63406 5.49647 8.17128 5.28571 7.66176C5.07494 7.15225 4.96708 6.60607 4.96832 6.05469C4.96832 4.93408 5.40533 3.87939 6.19635 3.08594C6.98737 2.29248 8.03961 1.85547 9.16022 1.85547C10.2808 1.85547 11.3306 2.29248 12.1241 3.08594C12.5145 3.47532 12.824 3.9381 13.0347 4.44761C13.2455 4.95712 13.3534 5.5033 13.3521 6.05469C13.3521 7.17529 12.9151 8.22998 12.1241 9.02344C11.3306 9.81689 10.2784 10.2539 9.16022 10.2539ZM18.1397 16.0645H16.0889V14.0137C16.0889 13.9062 16.001 13.8184 15.8936 13.8184H14.5264C14.419 13.8184 14.3311 13.9062 14.3311 14.0137V16.0645H12.2803C12.1729 16.0645 12.085 16.1523 12.085 16.2598V17.627C12.085 17.7344 12.1729 17.8223 12.2803 17.8223H14.3311V19.873C14.3311 19.9805 14.419 20.0684 14.5264 20.0684H15.8936C16.001 20.0684 16.0889 19.9805 16.0889 19.873V17.8223H18.1397C18.2471 17.8223 18.335 17.7344 18.335 17.627V16.2598C18.335 16.1523 18.2471 16.0645 18.1397 16.0645Z" fill="#130804"></path>
                                </svg>
                            </span>
                            {{ __('Sign Up') }}
                        </a>
                        <a class="site-btn gdt-btn" href="{{ route('login') }}">
                            <span>
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="path-1-outside-1_4_59" maskUnits="userSpaceOnUse" x="0" y="0" width="22" height="22" fill="black">
                                    <rect fill="white" width="22" height="22"></rect>
                                    <path d="M10.76 1C16.417 1 21 5.477 21 11C21 16.523 16.416 21 10.76 21C7.569 21 4.618 19.563 2.69 17.154C2.63595 17.0867 2.59598 17.0093 2.57246 16.9262C2.54894 16.8432 2.54234 16.7563 2.55307 16.6706C2.5638 16.585 2.59163 16.5024 2.6349 16.4277C2.67818 16.3531 2.73603 16.2879 2.805 16.236C2.94565 16.129 3.12243 16.0809 3.2979 16.102C3.47336 16.1231 3.63372 16.2117 3.745 16.349C4.58843 17.3972 5.65709 18.2421 6.87168 18.8208C8.08627 19.3995 9.41559 19.6973 10.761 19.692C15.676 19.692 19.661 15.8 19.661 11C19.661 6.2 15.676 2.308 10.761 2.308C9.4348 2.30283 8.12398 2.59213 6.92315 3.15502C5.72232 3.71791 4.66142 4.54035 3.817 5.563C3.70396 5.69904 3.54236 5.78569 3.36648 5.80454C3.19061 5.8234 3.01431 5.77299 2.875 5.664C2.80663 5.61123 2.74956 5.54524 2.70721 5.46997C2.66486 5.39469 2.63808 5.31167 2.62847 5.22583C2.61886 5.14 2.62662 5.05311 2.65127 4.97033C2.67593 4.88756 2.71699 4.81059 2.772 4.744C4.703 2.394 7.614 1 10.76 1ZM11.306 7.862L14.013 10.569C14.275 10.831 14.28 11.249 14.024 11.505L11.38 14.15C11.3179 14.2111 11.2444 14.2593 11.1636 14.2919C11.0828 14.3244 10.9963 14.3407 10.9092 14.3396C10.8221 14.3386 10.7361 14.3204 10.656 14.2859C10.576 14.2515 10.5036 14.2016 10.443 14.139C10.3805 14.0783 10.3307 14.0059 10.2963 13.9258C10.262 13.8457 10.2438 13.7597 10.2429 13.6726C10.2419 13.5855 10.2583 13.4991 10.2909 13.4183C10.3235 13.3375 10.3718 13.264 10.433 13.202L11.98 11.654L1.67 11.655C1.58291 11.6563 1.49642 11.6404 1.41551 11.6081C1.33461 11.5759 1.26089 11.5279 1.1986 11.467C1.13632 11.4061 1.08671 11.3335 1.05262 11.2534C1.01853 11.1732 1.00065 11.0871 1 11C1 10.639 1.3 10.346 1.67 10.346H11.938L10.38 8.787C10.3175 8.72631 10.2677 8.65385 10.2333 8.5738C10.199 8.49375 10.1808 8.40769 10.1799 8.32058C10.1789 8.23348 10.1953 8.14705 10.2279 8.06628C10.2605 7.98552 10.3088 7.91201 10.37 7.85C10.432 7.78919 10.5055 7.74122 10.5861 7.70885C10.6667 7.67648 10.7529 7.66034 10.8398 7.66136C10.9267 7.66238 11.0125 7.68054 11.0923 7.7148C11.1721 7.74906 11.2444 7.79874 11.305 7.861"></path>
                                    </mask>
                                    <path d="M10.76 1C16.417 1 21 5.477 21 11C21 16.523 16.416 21 10.76 21C7.569 21 4.618 19.563 2.69 17.154C2.63595 17.0867 2.59598 17.0093 2.57246 16.9262C2.54894 16.8432 2.54234 16.7563 2.55307 16.6706C2.5638 16.585 2.59163 16.5024 2.6349 16.4277C2.67818 16.3531 2.73603 16.2879 2.805 16.236C2.94565 16.129 3.12243 16.0809 3.2979 16.102C3.47336 16.1231 3.63372 16.2117 3.745 16.349C4.58843 17.3972 5.65709 18.2421 6.87168 18.8208C8.08627 19.3995 9.41559 19.6973 10.761 19.692C15.676 19.692 19.661 15.8 19.661 11C19.661 6.2 15.676 2.308 10.761 2.308C9.4348 2.30283 8.12398 2.59213 6.92315 3.15502C5.72232 3.71791 4.66142 4.54035 3.817 5.563C3.70396 5.69904 3.54236 5.78569 3.36648 5.80454C3.19061 5.8234 3.01431 5.77299 2.875 5.664C2.80663 5.61123 2.74956 5.54524 2.70721 5.46997C2.66486 5.39469 2.63808 5.31167 2.62847 5.22583C2.61886 5.14 2.62662 5.05311 2.65127 4.97033C2.67593 4.88756 2.71699 4.81059 2.772 4.744C4.703 2.394 7.614 1 10.76 1ZM11.306 7.862L14.013 10.569C14.275 10.831 14.28 11.249 14.024 11.505L11.38 14.15C11.3179 14.2111 11.2444 14.2593 11.1636 14.2919C11.0828 14.3244 10.9963 14.3407 10.9092 14.3396C10.8221 14.3386 10.7361 14.3204 10.656 14.2859C10.576 14.2515 10.5036 14.2016 10.443 14.139C10.3805 14.0783 10.3307 14.0059 10.2963 13.9258C10.262 13.8457 10.2438 13.7597 10.2429 13.6726C10.2419 13.5855 10.2583 13.4991 10.2909 13.4183C10.3235 13.3375 10.3718 13.264 10.433 13.202L11.98 11.654L1.67 11.655C1.58291 11.6563 1.49642 11.6404 1.41551 11.6081C1.33461 11.5759 1.26089 11.5279 1.1986 11.467C1.13632 11.4061 1.08671 11.3335 1.05262 11.2534C1.01853 11.1732 1.00065 11.0871 1 11C1 10.639 1.3 10.346 1.67 10.346H11.938L10.38 8.787C10.3175 8.72631 10.2677 8.65385 10.2333 8.5738C10.199 8.49375 10.1808 8.40769 10.1799 8.32058C10.1789 8.23348 10.1953 8.14705 10.2279 8.06628C10.2605 7.98552 10.3088 7.91201 10.37 7.85C10.432 7.78919 10.5055 7.74122 10.5861 7.70885C10.6667 7.67648 10.7529 7.66034 10.8398 7.66136C10.9267 7.66238 11.0125 7.68054 11.0923 7.7148C11.1721 7.74906 11.2444 7.79874 11.305 7.861" fill="white"></path>
                                    <path d="M2.69 17.154L2.92422 16.9665L2.92389 16.9661L2.69 17.154ZM2.805 16.236L2.98532 16.4758L2.98665 16.4748L2.805 16.236ZM3.745 16.349L3.97873 16.1609L3.97806 16.1601L3.745 16.349ZM10.761 19.692V19.392L10.7598 19.392L10.761 19.692ZM10.761 2.308L10.7598 2.608H10.761V2.308ZM3.817 5.563L4.04774 5.75473L4.04833 5.75401L3.817 5.563ZM2.875 5.664L3.05985 5.42771L3.0583 5.42651L2.875 5.664ZM2.772 4.744L3.00328 4.93508L3.00379 4.93446L2.772 4.744ZM14.013 10.569L13.8009 10.7811L14.013 10.569ZM14.024 11.505L13.8119 11.2929L13.8118 11.2929L14.024 11.505ZM11.38 14.15L11.5905 14.3638L11.5922 14.3621L11.38 14.15ZM10.443 14.139L10.6585 13.9301L10.652 13.9238L10.443 14.139ZM10.433 13.202L10.2208 12.9899L10.2194 12.9913L10.433 13.202ZM11.98 11.654L12.1922 11.8661L12.704 11.3539L11.98 11.354L11.98 11.654ZM1.67 11.655L1.66997 11.355L1.66545 11.355L1.67 11.655ZM1 11H0.699992L0.700008 11.0022L1 11ZM11.938 10.346V10.646H12.6619L12.1502 10.1339L11.938 10.346ZM10.38 8.787L10.5922 8.57491L10.589 8.57179L10.38 8.787ZM10.37 7.85L10.16 7.63574L10.1564 7.6393L10.37 7.85ZM10.76 1.3C16.258 1.3 20.7 5.64933 20.7 11H21.3C21.3 5.30467 16.576 0.7 10.76 0.7V1.3ZM20.7 11C20.7 16.3507 16.2571 20.7 10.76 20.7V21.3C16.5749 21.3 21.3 16.6953 21.3 11H20.7ZM10.76 20.7C7.6597 20.7 4.79503 19.3041 2.92422 16.9665L2.45578 17.3415C4.44097 19.8219 7.4783 21.3 10.76 21.3V20.7ZM2.92389 16.9661C2.89502 16.9302 2.87366 16.8888 2.8611 16.8445L2.28382 17.008C2.3183 17.1297 2.37689 17.2433 2.45611 17.3419L2.92389 16.9661ZM2.8611 16.8445C2.84853 16.8001 2.84501 16.7537 2.85074 16.7079L2.2554 16.6334C2.23967 16.7589 2.24934 16.8863 2.28382 17.008L2.8611 16.8445ZM2.85074 16.7079C2.85647 16.6622 2.87134 16.6181 2.89446 16.5782L2.37535 16.2773C2.31191 16.3867 2.27112 16.5078 2.2554 16.6334L2.85074 16.7079ZM2.89446 16.5782C2.91757 16.5383 2.94847 16.5035 2.98531 16.4758L2.62469 15.9962C2.52358 16.0723 2.43879 16.1679 2.37535 16.2773L2.89446 16.5782ZM2.98665 16.4748C3.06525 16.415 3.16404 16.3881 3.26209 16.3999L3.3337 15.8042C3.08083 15.7738 2.82605 15.843 2.62335 15.9972L2.98665 16.4748ZM3.26209 16.3999C3.36014 16.4117 3.44976 16.4612 3.51194 16.5379L3.97806 16.1601C3.81768 15.9622 3.58658 15.8346 3.3337 15.8042L3.26209 16.3999ZM3.51127 16.5371C4.38294 17.6204 5.48738 18.4935 6.74263 19.0916L7.00072 18.55C5.8268 17.9906 4.79392 17.1741 3.97873 16.1609L3.51127 16.5371ZM6.74263 19.0916C7.99789 19.6897 9.37172 19.9975 10.7622 19.992L10.7598 19.392C9.45946 19.3971 8.17464 19.1093 7.00072 18.55L6.74263 19.0916ZM10.761 19.992C15.835 19.992 19.961 15.9723 19.961 11H19.361C19.361 15.6277 15.517 19.392 10.761 19.392V19.992ZM19.961 11C19.961 6.02767 15.835 2.008 10.761 2.008V2.608C15.517 2.608 19.361 6.37233 19.361 11H19.961ZM10.7622 2.008C9.39156 2.00266 8.03686 2.30165 6.79582 2.88338L7.05048 3.42666C8.21111 2.88261 9.47803 2.603 10.7598 2.608L10.7622 2.008ZM6.79582 2.88338C5.55478 3.46512 4.45836 4.3151 3.58567 5.37199L4.04833 5.75401C4.86447 4.76561 5.88985 3.9707 7.05048 3.42666L6.79582 2.88338ZM3.58626 5.37127C3.52309 5.4473 3.43278 5.49572 3.3345 5.50625L3.39847 6.10283C3.65193 6.07566 3.88483 5.95079 4.04774 5.75473L3.58626 5.37127ZM3.3345 5.50625C3.23622 5.51679 3.1377 5.48862 3.05985 5.42771L2.69015 5.90029C2.89093 6.05735 3.145 6.13001 3.39847 6.10283L3.3345 5.50625ZM3.0583 5.42651C3.02177 5.39832 2.99129 5.36307 2.96867 5.32286L2.44575 5.61707C2.50784 5.72741 2.59148 5.82414 2.6917 5.90149L3.0583 5.42651ZM2.96867 5.32286C2.94605 5.28265 2.93174 5.23831 2.92661 5.19246L2.33034 5.25921C2.34442 5.38503 2.38367 5.50673 2.44575 5.61707L2.96867 5.32286ZM2.92661 5.19246C2.92148 5.14661 2.92562 5.10019 2.93879 5.05598L2.36376 4.88469C2.32762 5.00603 2.31625 5.13339 2.33034 5.25921L2.92661 5.19246ZM2.93879 5.05598C2.95196 5.01176 2.97389 4.97065 3.00328 4.93508L2.54072 4.55292C2.46008 4.65052 2.3999 4.76335 2.36376 4.88469L2.93879 5.05598ZM3.00379 4.93446C4.87753 2.65414 7.70333 1.3 10.76 1.3V0.7C7.52467 0.7 4.52847 2.13386 2.54021 4.55354L3.00379 4.93446ZM11.0939 8.07413L13.8009 10.7811L14.2251 10.3569L11.5181 7.64987L11.0939 8.07413ZM13.8009 10.7811C13.9505 10.9307 13.946 11.1587 13.8119 11.2929L14.2361 11.7171C14.614 11.3393 14.5995 10.7313 14.2251 10.3569L13.8009 10.7811ZM13.8118 11.2929L11.1678 13.9379L11.5922 14.3621L14.2362 11.7171L13.8118 11.2929ZM11.1695 13.9362C11.1357 13.9696 11.0955 13.9959 11.0515 14.0136L11.2757 14.5702C11.3932 14.5228 11.5002 14.4527 11.5905 14.3638L11.1695 13.9362ZM11.0515 14.0136C11.0074 14.0314 10.9602 14.0402 10.9127 14.0397L10.9057 14.6396C11.0324 14.6411 11.1581 14.6175 11.2757 14.5702L11.0515 14.0136ZM10.9127 14.0397C10.8652 14.0391 10.8183 14.0292 10.7746 14.0104L10.5374 14.5615C10.6538 14.6116 10.779 14.6381 10.9057 14.6396L10.9127 14.0397ZM10.7746 14.0104C10.731 13.9916 10.6915 13.9643 10.6584 13.9302L10.2276 14.3478C10.3157 14.4388 10.4211 14.5114 10.5374 14.5615L10.7746 14.0104ZM10.652 13.9238C10.6179 13.8907 10.5907 13.8512 10.572 13.8075L10.0206 14.0441C10.0706 14.1605 10.1431 14.2659 10.234 14.3542L10.652 13.9238ZM10.572 13.8075C10.5533 13.7638 10.5433 13.7169 10.5428 13.6694L9.94287 13.6758C9.94423 13.8025 9.97065 13.9277 10.0206 14.0441L10.572 13.8075ZM10.5428 13.6694C10.5423 13.6219 10.5512 13.5747 10.569 13.5307L10.0127 13.3059C9.96527 13.4234 9.94152 13.5491 9.94287 13.6758L10.5428 13.6694ZM10.569 13.5307C10.5868 13.4866 10.6132 13.4465 10.6466 13.4127L10.2194 12.9913C10.1305 13.0815 10.0602 13.1884 10.0127 13.3059L10.569 13.5307ZM10.6452 13.4141L12.1922 11.8661L11.7678 11.4419L10.2208 12.9899L10.6452 13.4141ZM11.98 11.354L1.66997 11.355L1.67003 11.955L11.98 11.954L11.98 11.354ZM1.66545 11.355C1.61794 11.3558 1.57076 11.3471 1.52663 11.3295L1.30439 11.8868C1.42207 11.9337 1.54788 11.9569 1.67455 11.955L1.66545 11.355ZM1.52663 11.3295C1.4825 11.3119 1.44229 11.2857 1.40832 11.2525L0.988887 11.6815C1.07948 11.7701 1.18671 11.8399 1.30439 11.8868L1.52663 11.3295ZM1.40832 11.2525C1.37435 11.2193 1.34729 11.1797 1.32869 11.136L0.776546 11.3708C0.826126 11.4874 0.898293 11.593 0.988887 11.6815L1.40832 11.2525ZM1.32869 11.136C1.3101 11.0922 1.30035 11.0453 1.29999 10.9978L0.700008 11.0022C0.700954 11.1289 0.726966 11.2542 0.776546 11.3708L1.32869 11.136ZM1.3 11C1.3 10.8114 1.45886 10.646 1.67 10.646V10.046C1.14114 10.046 0.7 10.4666 0.7 11H1.3ZM1.67 10.646H11.938V10.046H1.67V10.646ZM12.1502 10.1339L10.5922 8.57494L10.1678 8.99906L11.7258 10.5581L12.1502 10.1339ZM10.589 8.57179C10.5549 8.53869 10.5277 8.49916 10.509 8.4555L9.95761 8.6921C10.0076 8.80854 10.0801 8.91393 10.171 9.00221L10.589 8.57179ZM10.509 8.4555C10.4903 8.41183 10.4803 8.36489 10.4798 8.31738L9.87988 8.32378C9.88123 8.45048 9.90765 8.57566 9.95761 8.6921L10.509 8.4555ZM10.4798 8.31738C10.4793 8.26987 10.4882 8.22273 10.506 8.17867L9.94973 7.95389C9.90226 8.07137 9.87852 8.19709 9.87988 8.32378L10.4798 8.31738ZM10.506 8.17867C10.5238 8.13462 10.5502 8.09452 10.5836 8.0607L10.1564 7.6393C10.0675 7.7295 9.9972 7.83642 9.94973 7.95389L10.506 8.17867ZM10.58 8.06423C10.6138 8.03106 10.6539 8.0049 10.6979 7.98724L10.4743 7.43045C10.357 7.47754 10.2502 7.54731 10.16 7.63577L10.58 8.06423ZM10.6979 7.98724C10.7418 7.96958 10.7889 7.96078 10.8363 7.96134L10.8433 7.36138C10.717 7.3599 10.5916 7.38337 10.4743 7.43045L10.6979 7.98724ZM10.8363 7.96134C10.8836 7.9619 10.9304 7.9718 10.974 7.99049L11.2106 7.43912C11.0945 7.38928 10.9697 7.36287 10.8433 7.36138L10.8363 7.96134ZM10.974 7.99049C11.0175 8.00918 11.057 8.03628 11.09 8.07023L11.52 7.65177C11.4319 7.56121 11.3267 7.48895 11.2106 7.43912L10.974 7.99049Z" fill="white" mask="url(#path-1-outside-1_4_59)"></path>
                                </svg>
                            </span>
                            {{ __('Log In') }}
                        </a>
                   @endauth
                </div>
                <div class="header-hamburger d-xxl-none">
                   <a class="sidebar-toggle" href="javascript:void(0)">
                   <span class="menu-icon"><span></span></span>
                   </a>
                </div>
             </div>
          </div>
       </div>
    </div>
 </header>

 @push('js')
<script>
    $('.change_lang').on('click', function(e) {
        e.preventDefault();
        var url = $(this).attr('href');
        $.get(url, function(data) {
            location.reload();
        });
    });
</script>
 @endpush
