<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('loan_no')->unique();
            $table->unsignedBigInteger('txn_id');
            $table->unsignedBigInteger('loan_plan_id')->index('loans_loan_plan_id_foreign');
            $table->unsignedBigInteger('user_id')->index('loans_user_id_foreign');
            $table->decimal('amount', 10)->nullable();
            $table->json('submitted_data')->nullable();
            $table->dateTime('cancel_date')->nullable();
            $table->decimal('cancel_fee')->nullable();
            $table->enum('status', ['reviewing', 'running', 'due', 'completed', 'rejected', 'cancelled'])->default('reviewing');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loans');
    }
};
